struct SItem
{
    //    int docNo;
    int pageNo;
    int index;
    int wordId;
    int keywordIndex;
    int previousWordId;
    //    int newIndex;
    //    int distance;
    //    int foundcount;
    int fontSize;
    int wcount;
    bool inTirnak;
    bool isSimilar;
    bool similarHasReal;
    int similarity;
    int groupId;
    //    bool must;
};

__kernel void search(
                     __global struct SItem* input,
                     __global int* output,
                     const unsigned int count,
                     const unsigned int totalcount,
                     const unsigned int pagecount,
                     const unsigned int keywordcount)
{
    
    size_t i = get_global_id(0);
    int i1 = i / count;
    int i2 = i % count;

    output[i*2]=0;
    output[i*2+1]=0;

    if (i>=totalcount) return;

    if (i2<i1) return;
    
    int scopedistance = 150;

    
    struct SItem item1 = input[i1];
    struct SItem item2 = input[i2];
    
    int item1FactorIndex = (item1.pageNo-1)*keywordcount + item1.keywordIndex;
    int item2FactorIndex = (item2.pageNo-1)*keywordcount + item2.keywordIndex;
    
    int factorItem1=0;
    int factorItem2=0;
    
    if (item1.index!=item2.index) {
        int dist = item1.index - item2.index;
        if (abs(dist)<scopedistance) {
            
            if ((item1.inTirnak || item2.inTirnak) && item1.groupId!=item2.groupId)
                return;

            if (item1.inTirnak && item2.inTirnak) {
                if (dist==1) {
                    if (item1.previousWordId>-1) {
                        if (item1.previousWordId!=item2.wordId) {
                            return;
                        }
                    } else return;
                } else if (dist==-1) {
                    if (item2.previousWordId>-1) {
                        if (item2.previousWordId!=item1.wordId) {
                            return;
                        }
                    } else return;
                } else {
                    //    if (item1.previousWordArray || item2.previousWordArray) {
                    return;
                    //    }
                }
            }
            
            if (item1.wordId==item2.wordId) {
                if (item1.inTirnak || item2.inTirnak) return;
                factorItem1 = item1.fontSize * 50 - item1.wcount;
            } else {
                int ds = 20000000;
                if (dist==1) {
                    if (item1.previousWordId>-1) {
                        if (item1.previousWordId==item2.wordId) {
                            ds = 25000000;
                        }
                    }
                } else if (dist==-1) {
                    if (item2.previousWordId>-1) {
                        if (item2.previousWordId==item1.wordId) {
                            ds = 25000000;
                        }
                    }
                }
                
                factorItem1 = item1.fontSize * 50 + ds / (dist * dist) - item1.wcount - item2.wcount; // - abs((doc.pageCount) - item1.pageNo) ;
                factorItem2 = item2.fontSize * 50 +  ds / (dist * dist) - item2.wcount - item1.wcount; // - abs((doc.pageCount) - item2.pageNo);
            }
        }
    } else {
        if (item1.inTirnak || item2.inTirnak) return;
        factorItem1 = item1.fontSize * 50 - item1.wcount;
    }
    
    output[i*2]=factorItem1;
    output[i*2+1]=factorItem2;
}

